terraform {
  required_version = ">= 1.0.0, < 2.0.0"

  required_providers {
    aws = {
      source  = "hashicorp/aws"
      version = "~> 4.0"
    }
  }
}

provider "aws" {
  region = "us-east-2"
}

# Utworzenie KMS Customer Managed Key (CMK).
resource "aws_kms_key" "cmk" {
  policy = data.aws_iam_policy_document.cmk_admin_policy.json

  # Definiujemy krótkie okno usunięcia, ponieważ te klucze są używane jedynie
  # do celów edukacyjnych i testowych. Ponadto chcemy zminimalizować koszty
  # usługi AWS.
  deletion_window_in_days = 7
}

# Prosta polityka, dzięki której bieżący użytkownik IAM
# staje się administratorem CMK.
data "aws_iam_policy_document" "cmk_admin_policy" {
  statement {
    effect    = "Allow"
    resources = ["*"]
    actions   = ["kms:*"]
    principals {
      type        = "AWS"
      identifiers = [data.aws_caller_identity.self.arn]
    }
  }
}

# Wyszukiwanie szczegółów dotyczących bieżącego użytkownika.
data "aws_caller_identity" "self" {}

# Utworzenie aliasu dla CMK.
resource "aws_kms_alias" "cmk" {
  name          = "alias/${var.alias}"
  target_key_id = aws_kms_key.cmk.id
}
